# D.E. Beaudette
# 2001-03-26
# filled polygon panel function, accounts for missing data
# there should be multiple records per date/time unit, 
# from which min and max are plotted as the polygon outline
panel.tsplot <- function(x, y, groups, alpha, range.fun='minmax', ...) 
  {
  
  # deal with missing groups
  if(missing(groups))
	  groups <- 1
  
  # define default alpha is missing
  if(missing(alpha))
	  alpha <- 0.8

  # generate local DF, re-setting grouping factor
  d <- data.frame(date=x, val=y, g=groups)
  d$g <- factor(d$g)
  
  # levels of groups, used for setting colors
  ll <- levels(d$g)

  # layout simple grid
  panel.grid(h=-1, v=-1)
	
  # iterate over groups
  by(d, d$g, function(d_i) 
	{
	# get number of the current group
	m <- match(unique(d_i$g), ll)
	
	# just in case, order by time variable		
	d_i <- d_i[order(d_i$date), ]		

	# id missing y values
	s.rle <- rle(is.na(d_i$val))
	s.is.data.segments <- s.rle$lengths[which(! s.rle$value)]
	s.is.data.labels <- rep(1:length(s.is.data.segments), times=s.is.data.segments)
	
	# keep only the data, and label segments of contiguous non-missing obs. 
	d_i.clean <- na.omit(d_i)
	d_i.clean$segment <- factor(s.is.data.labels)
		
	# within each segment make and plot polygon
	# generate vectors for polygon boundary
	by(d_i.clean, d_i.clean$segment, function(seg_i)
	  {
	  # extract a unique vector of dates for this segment
	  d.date <- unique(seg_i$date)
    
	  # compute date-wise max and min values 
    if(range.fun == 'minmax')
	    {
      d.max <- with(seg_i, tapply(val, date, max))
	    d.min <- with(seg_i, tapply(val, date, min))
	    }
		else if(range.fun == 'IQR')
      {
      d.max <- with(seg_i, tapply(val, date, quantile, prob=0.75))
      d.min <- with(seg_i, tapply(val, date, quantile, prob=0.25))
      }
    
    # if there is no difference in range, plot a line for this group / segment
    if(sum(abs(d.max - d.min)) < .Machine$double.eps)
      {
      print('plotting lines...')
      panel.lines(x=d.date, y=d.max, col=trellis.par.get('superpose.lines')$col[m])
      }
    
    # plot the polygon for this group / segment
    else
      {
      print('plotting polygons...')
      panel.polygon(x=c(d.date, rev(d.date)), y=c(d.max, rev(d.min)), 
      col=trellis.par.get('superpose.polygon')$col[m], 
      border='black', alpha=alpha)
      }

	  })
	
	})
  }
